<?php

// ibProArcade Install/Update Script for vBulletin 3.x.x
// (C)opyright by MrZeropage

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

$phrasegroups = array();
$specialtemplates = array();
$actiontemplates = array();
$globaltemplates = array();

define("ROOT_PATH","./");
require_once('./global.php');
require_once('./includes/adminfunctions_template.php');
require "./includes/config.php";

$sql_driver = ROOT_PATH."arcade/functions/dbclass.php";

require $sql_driver;

$DB = new db_driver;

$version = "v2.6.7+";
$action=$_REQUEST['do'];

$override=0;
if ($action=="override")
{ $override=1; $action="go"; }

if ($action=="go")
{

// vB-version detection based on config.php by MrZeropage
if ($config['MasterServer']['servername'] != "")
{
	// vBulletin 3.5.x
	$DB->obj['sql_database']     = $config['Database']['dbname'];
	$DB->obj['sql_user']         = $config['MasterServer']['username'];
	$DB->obj['sql_pass']         = $config['MasterServer']['password'];
	$DB->obj['sql_host']         = $config['MasterServer']['servername'];
	$DB->obj['sql_tbl_prefix']   = $config['Database']['tableprefix'];

	if ($override==0)
	{
		echo "==============================<br />";
		echo "Welcome to ibProArcade ".$version."<br />";
		echo "==============================<br />";
		echo "<br />";
		echo "<br />";
		echo "You should not use this Installer-Script, just import the Product-XML-File in the Product/PlugIn-System of vBulletin.<br /><br />Installation cancelled.";
		exit;
	}
}
else
{
	// vBulletin 3.0.x
	$DB->obj['sql_database']     = $dbname;
	$DB->obj['sql_user']         = $dbusername;
	$DB->obj['sql_pass']         = $dbpassword;
	$DB->obj['sql_host']         = $servername;
	$DB->obj['sql_tbl_prefix']   = $tableprefix;
}

$DB->connect();

echo "==============================<br />";
echo "Welcome to ibProArcade ".$version."<br />";
echo "==============================<br />";
echo "<br />";
echo "<br />";
echo "Checking and Creating Tables...........";

// make sure all tables are there
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_games_settings` (arcade_status tinyint(1) NOT NULL default '1', g_display_sort varchar(15) NOT NULL default '', g_display_order varchar(4) NOT NULL default '', scores_amount mediumint(8) NOT NULL default '10', next_day int(10) NOT NULL default '0', skin tinyint(1) NOT NULL default '0', use_cats tinyint(1) NOT NULL default '0', log tinyint(1) NOT NULL default '0', score_type char(3) NOT NULL default '', crown_type tinyint(1) NOT NULL default '0', show_new MEDIUMINT( 8 ) DEFAULT '0' NOT NULL, show_new_frame MEDIUMINT( 5 ) DEFAULT '0' NOT NULL, show_active TEXT NOT NULL, mod_notes TEXT NOT NULL, most_users_on MEDIUMINT( 8 ) DEFAULT '0' NOT NULL, auto_prune TINYINT( 1 ) DEFAULT '0' NOT NULL, auto_prune_time MEDIUMINT( 8 ) DEFAULT '0' NOT NULL, auto_prune_time2 MEDIUMINT( 7 ) DEFAULT '0' NOT NULL, banned_ips TEXT NOT NULL, games_pp MEDIUMINT( 8 ) DEFAULT '0' NOT NULL, allow_user_skin TINYINT( 1 ) DEFAULT 0 NOT NULL, user_choices TEXT NOT NULL, def_cat MEDIUMINT( 8 ) DEFAULT '1' NOT NULL, cats_per_tr MEDIUMINT( 8 ) DEFAULT '0' NOT NULL, show_crowns TINYINT( 1 ) DEFAULT '1' NOT NULL, show_t_won TINYINT( 1 ) DEFAULT '1' NOT NULL, score_sep VARCHAR( 1 ) DEFAULT '0' NOT NULL, dec_amount TINYINT( 2 ) DEFAULT '0' NOT NULL)");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_games_savedGames` (gid int(11) NOT NULL default '0',uname varchar(40) NOT NULL default '',gameData text NOT NULL,savedate datetime NOT NULL default '0000-00-00 00:00:00')");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_games_scores` (s_id int(11) NOT NULL auto_increment, mid int(11) NOT NULL default '0',gid int(11) NOT NULL default '0', name text NOT NULL, score FLOAT NOT NULL default '0', ip text NOT NULL, comment text NOT NULL, datescored int(10) NOT NULL, PRIMARY KEY (s_id))");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_games_list` (gid int(11) NOT NULL auto_increment, gname varchar(40) NOT NULL default '', gwords text NOT NULL, gcount int(11) NOT NULL default '0', gtitle varchar(40) NOT NULL default '', bgcolor varchar(6) NOT NULL default '000', active tinyint(1) NOT NULL default '1', gwidth int(11) NOT NULL default '400', gheight int(11) NOT NULL default '400', position mediumint(8) NOT NULL default '1', gcat int(2) NOT NULL default '1', object text NOT NULL, gkeys text NOT NULL, added INT( 10 ) DEFAULT '0' NOT NULL, g_rating TINYINT( 1 ) DEFAULT '0' NOT NULL, g_raters TEXT NOT NULL, highscore_type VARCHAR ( 4 ) DEFAULT 'high' NOT NULL, UNIQUE KEY gid (gid))");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_games_cats` (c_id mediumint(8) NOT NULL auto_increment, cat_name varchar(32) NOT NULL default '', active tinyint(1) NOT NULL default '1', show_all TINYINT( 1 ) DEFAULT '0' NOT NULL, pos TINYINT( 2 ) DEFAULT '1' NOT NULL, password VARCHAR( 32 ) NOT NULL, num_of_games MEDIUMINT( 8 ) DEFAULT '0' NOT NULL, PRIMARY KEY (c_id))");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_tournament_players` (mid int(11) NOT NULL default '0', tid int(11) NOT NULL default '0', rung int(11) NOT NULL default '0', rungscore FLOAT NOT NULL default '0', faceoff int(11) NOT NULL default '0', timeplayed int(10) NOT NULL default '0', timesplayed int(11) NOT NULL default '0')");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_tournaments` (tid int(11) NOT NULL auto_increment, gid int(11) NOT NULL default '0', numplayers int(11) NOT NULL default '0', champion text NOT NULL, datestarted int(10) NOT NULL default '0', UNIQUE KEY tid (tid))");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_games_champs` (champ_gid MEDIUMINT( 8 ) DEFAULT '0' NOT NULL , champ_gtitle VARCHAR( 40 ) NOT NULL , champ_mid MEDIUMINT( 8 ) DEFAULT '0' NOT NULL , champ_name VARCHAR( 32 ) NOT NULL , champ_date INT( 10 ) DEFAULT '0' NOT NULL , champ_score FLOAT( 11 ) DEFAULT '0' NOT NULL)");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_badwords` (wid int(3) NOT NULL auto_increment, type varchar(250) NOT NULL default '', swop varchar(250) NOT NULL default '', m_exact tinyint(1) NOT NULL default '0', UNIQUE KEY wid (wid))");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_macro` (macro_id smallint(3) NOT NULL auto_increment, macro_value varchar(200) default NULL, macro_replace text, can_remove tinyint(1) default '0', macro_set smallint(3) NOT NULL default '0', PRIMARY KEY  (macro_id), KEY macro_set (macro_set))");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_games_league` (`mid` bigint(20) NOT NULL default '0',`gid` bigint(20) NOT NULL default '0', `position` bigint(20) NOT NULL default '0', `points` bigint(20) NOT NULL default '0') TYPE=MyISAM");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_tournament_players_statut` (tid INT( 11 ) DEFAULT '0' NOT NULL, mid INT( 11 ) DEFAULT '0' NOT NULL, statut TINYINT( 1 ) DEFAULT '0' NOT NULL)");
$DB->query("CREATE TABLE IF NOT EXISTS `ibf_games_session` (sessid int(10) NOT NULL auto_increment, gameid int(11) NOT NULL default '0', gname varchar(30) NOT NULL default '', gtitle varchar(255) NOT NULL default '', randchar1 varchar(30) NOT NULL default '0', randchar2 varchar(30) NOT NULL default '0', start int(10) NOT NULL default '0', mid mediumint(8) NOT NULL default '0', mname varchar(255) NOT NULL default '', timediff int(11) NOT NULL default '0', sessd tinyint(1) NOT NULL default '0', PRIMARY KEY (sessid))");

echo "done<br />";
echo "Checking and Adapting Tables...........";

// now we check all needed columns
$ok=0; $missing=0; $truncate=0; $newleague=0; $champs=0;

if($DB->field_exists("in_game","ibf_session")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_session` ADD in_game VARCHAR( 32 ) NOT NULL"); $missing++; }

if($DB->field_exists("randgid","ibf_games_session")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_session` ADD randgid VARCHAR(30) NOT NULL DEFAULT '0'"); $missing++; }

if($DB->field_exists("randgid2","ibf_games_session")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_session` ADD randgid2 VARCHAR(30) NOT NULL DEFAULT '0'"); $missing++; }

if($DB->field_exists("PNscore","ibf_games_session")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_session` ADD PNscore FLOAT NOT NULL DEFAULT '0'"); $missing++; }

if($DB->field_exists("arcade_ban","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD arcade_ban tinyint(1) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("times_played","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD times_played int(11) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("is_arcade_mod","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD is_arcade_mod TINYINT( 1 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("fav_games","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD fav_games TEXT NOT NULL"); $missing++; }

if($DB->field_exists("user_sort","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD user_sort VARCHAR( 15 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("user_order","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD user_order VARCHAR( 4 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("user_g_pp","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD user_g_pp MEDIUMINT( 8 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("user_s_pp","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD user_s_pp MEDIUMINT( 8 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("def_g_cat","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD def_g_cat MEDIUMINT( 8 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("game_skin","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD game_skin TINYINT( 1 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("arcade_mod_privs","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD arcade_mod_privs TEXT NOT NULL"); $missing++; }

if($DB->field_exists("arcade_pmactive","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD arcade_pmactive tinyint(1) DEFAULT '1' NOT NULL"); $missing++; }

if($DB->field_exists("games_played","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD games_played int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("time_played","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD time_played int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("arcade_points","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD arcade_points int(11) NOT NULL default '500'"); $missing++; }

if($DB->field_exists("arcade_spent","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD arcade_spent int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("arcade_won","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD arcade_won int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("arcade_high","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD arcade_high int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("create_tourney","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD create_tourney tinyint(1) NOT NULL default '1'"); $missing++; }

if($DB->field_exists("arcade_sess_gid","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD arcade_sess_gid MEDIUMINT(8) NOT NULL"); $missing++; }

if($DB->field_exists("arcade_sess_start","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD arcade_sess_start INT(11) NOT NULL"); $missing++; }

if($DB->field_exists("arcade_gtype","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD arcade_gtype INT(11) NOT NULL"); $missing++; }

if($DB->field_exists("arcade_session","ibf_user")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_user` ADD arcade_session MEDIUMINT(8) NOT NULL"); $missing++; }

if($DB->field_exists("arcade_access","ibf_usergroup")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_usergroup` ADD arcade_access TINYINT( 1 ) DEFAULT '1' NOT NULL"); $missing++; }

if($DB->field_exists("p_require","ibf_usergroup")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_usergroup` ADD p_require MEDIUMINT( 8 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("max_play","ibf_usergroup")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_usergroup` ADD max_play MEDIUMINT( 8 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("ppd_require","ibf_usergroup")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_usergroup` ADD ppd_require MEDIUMINT( 8 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("ibpa_cats","ibf_usergroup")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_usergroup` ADD ibpa_cats MEDIUMTEXT NOT NULL"); $missing++; }

if($DB->field_exists("tourney","ibf_usergroup")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_usergroup` ADD `tourney` TINYINT( 1 ) DEFAULT '1' NOT NULL"); $missing++; }

if($DB->field_exists("gtime","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD gtime int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("gtotalscore","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD gtotalscore float NOT NULL default '0'"); $missing++; }

if($DB->field_exists("strict_cat","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD strict_cat tinyint(4) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("record_score","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD record_score tinyint(1) NOT NULL default '1'"); $missing++; }

if($DB->field_exists("tourney_use","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD tourney_use tinyint(1) NOT NULL default '1'"); $missing++; }

if($DB->field_exists("jackpot_won","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD jackpot_won int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("jackpot_paid","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD jackpot_paid int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("decpoints","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD decpoints tinyint(4) NOT NULL default '0';"); $missing++; }

if($DB->field_exists("license","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD license TEXT NOT NULL;"); $missing++; }

if($DB->field_exists("bestscore","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD bestscore FLOAT"); $missing++; }

if($DB->field_exists("bestmid","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD bestmid MEDIUMINT( 8 ) DEFAULT '0'"); $missing++; }

if($DB->field_exists("cost","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD cost decimal(30,5) NOT NULL DEFAULT '0.00000'"); $missing++; }

if($DB->field_exists("jackpot","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD jackpot decimal(30,5) NOT NULL DEFAULT '0.00000'"); $missing++; }

if($DB->field_exists("jackpot_type","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_list` ADD jackpot_type decimal(30,5) NOT NULL DEFAULT '-1'"); $missing++; }

if($DB->field_exists("game_type","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE ibf_games_list ADD `game_type` tinyint(1) NOT NULL DEFAULT '0'"); $missing++; }

if($DB->field_exists("filesize","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE ibf_games_list ADD `filesize` MEDIUMINT(8) NOT NULL"); $missing++; }

if($DB->field_exists("besttime","ibf_games_list")) { $ok++; } else
{ $DB->query("ALTER TABLE ibf_games_list ADD `besttime` INT(11) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("timespent","ibf_games_scores")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_scores` ADD timespent int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("description","ibf_games_cats")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_cats` ADD description text NOT NULL"); $missing++; }

if($DB->field_exists("skin","ibf_games_cats")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_cats` ADD skin int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("use_announce","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD use_announce int(1) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("announcement","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD announcement text NOT NULL"); $missing++; }

if($DB->field_exists("announcement_parsed","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD announcement_parsed text NOT NULL"); $missing++; }

if($DB->field_exists("games_pr","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD games_pr MEDIUMINT( 8 ) DEFAULT '4' NOT NULL"); $missing++; }

if($DB->field_exists("league_scores","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD league_scores varchar(255) NOT NULL default '10,9,8,7,6,5,4,3,2,1,0'"); $missing++; }

if($DB->field_exists("arcade_language","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD arcade_language varchar(5) NOT NULL default 'en'"); $missing++; }

if($DB->field_exists("default_points","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD default_points int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("post_conversion","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD post_conversion int(11) NOT NULL default '1000'"); $missing++; } 

if($DB->field_exists("use_inpoints","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD use_inpoints tinyint(1) NOT NULL default '0'"); $missing++; } 

if($DB->field_exists("show_popular","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD show_popular tinyint(1) NOT NULL default '0'"); $missing++; } 

if($DB->field_exists("number_format","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD number_format varchar(5) NOT NULL default '".$INFO[number_format]."'"); $missing++; }

if($DB->field_exists("arcade_date","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD arcade_date varchar(20) NOT NULL default '".$INFO[clock_short]."'"); $missing++; }

if($DB->field_exists("mostusers","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD mostusers int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("mostusersdate","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD mostusersdate int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("checkmost","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD checkmost tinyint(1) NOT NULL default '1'"); $missing++; }

if($DB->field_exists("notification","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD notification text NOT NULL"); $missing++; }

if($DB->field_exists("ladder_qual_color","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `ladder_qual_color` VARCHAR(10) DEFAULT 'A0FEA0' NOT NULL"); $missing++; }

if($DB->field_exists("ladder_disqual_color","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `ladder_disqual_color` VARCHAR(10) DEFAULT 'C22424' NOT NULL"); $missing++; }

if($DB->field_exists("ladder_elim_color","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `ladder_elim_color` VARCHAR(10) DEFAULT '787878' NOT NULL"); $missing++; }

if($DB->field_exists("ladder_color","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `ladder_color` VARCHAR(10) DEFAULT '000000' NOT NULL"); $missing++; }

if($DB->field_exists("ladder_empty_color","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `ladder_empty_color` VARCHAR(10) DEFAULT 'FFFFFF' NOT NULL"); $missing++; }

if($DB->field_exists("games_new","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `games_new` MEDIUMINT( 8 ) DEFAULT '15' NOT NULL"); $missing++; }

if($DB->field_exists("games_popular","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `games_popular` MEDIUMINT( 8 ) DEFAULT '15' NOT NULL"); $missing++; }

if($DB->field_exists("tourney_limit1","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `tourney_limit1` MEDIUMINT( 8 ) DEFAULT '3' NOT NULL"); $missing++; }

if($DB->field_exists("tourney_limit2","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `tourney_limit2` MEDIUMINT( 8 ) DEFAULT '7' NOT NULL"); $missing++; }

if($DB->field_exists("msgsys_hscore","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_hscore` tinyint(1) DEFAULT '1' NOT NULL"); $missing++; }

if($DB->field_exists("msgsys_hscore_text","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_hscore_text` text NOT NULL");
  $DB->query("UPDATE ibf_games_settings SET msgsys_hscore_text='Hello %NAME%,\n\nyour highscore in the game [b]%GAME%[/b] was beaten by [b][i]%CHAMP%[/i][/b]\n\n%LINKGAME|Click here% to play [i]%GAME%[/i] and claim back the highscore, or %LINKHIGH|click here% to see the highscores.'"); 
  $missing++; }

if($DB->field_exists("msgsys_tstart","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_tstart` tinyint(1) DEFAULT '1' NOT NULL"); $missing++; }

if($DB->field_exists("msgsys_tstart_text","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_tstart_text` text NOT NULL");
  $DB->query("UPDATE ibf_games_settings SET msgsys_tstart_text='Hello %NAME%,\n\nthe [b]%GAME%[/b]-Tournament just started.\n\n%LINK|Click here% to view the Tournament and make your match.'");
  $missing++; }

if($DB->field_exists("msgsys_tadvance","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_tadvance` tinyint(1) DEFAULT '1' NOT NULL"); $missing++; }

if($DB->field_exists("msgsys_tadvance_text","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_tadvance_text` text NOT NULL");
  $DB->query("UPDATE ibf_games_settings SET msgsys_tadvance_text='Hello %NAME%,\n\ncongratulations, you have beaten [i]%OTHER%[/i] in the %GAME%-Tournament, so you advance to the next round.\n\n%LINK|Click here% to view the Tournament.'");
  $missing++; }

if($DB->field_exists("msgsys_telim","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_telim` tinyint(1) DEFAULT '1' NOT NULL"); $missing++; }

if($DB->field_exists("msgsys_telim_text","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_telim_text` text NOT NULL");
  $DB->query("UPDATE ibf_games_settings SET msgsys_telim_text='Hello %NAME%,\n\nyou have been beaten in [b]%GAME%[/b]-Tournament by [i]%OTHER%[/i]\n\n%LINK|Click here% to view the Tournament.'");
  $missing++; }

if($DB->field_exists("msgsys_twin","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_twin` tinyint(1) DEFAULT '1' NOT NULL"); $missing++; }

if($DB->field_exists("msgsys_twin_text","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_twin_text` text NOT NULL");
  $DB->query("UPDATE ibf_games_settings SET msgsys_twin_text='Hello %NAME%,\n\nCONGRATULATIONS, you are the winner of the [b]%GAME%[/b]-Tournament !\n\n%LINK|Click here% to view the final standings.'"); 
  $missing++; }

if($DB->field_exists("msgsys_tremind_text","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_tremind_text` text NOT NULL");
  $DB->query("UPDATE ibf_games_settings SET msgsys_tremind_text='Hello %NAME%,\n\nplease remember to make your game in the [b]%GAME%-Tournament[/b]\n\n%LINK|Click here% to view this tournament.'");
  $missing++; }

if($DB->field_exists("msgsys_tdisqual_text","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `msgsys_tdisqual_text` text NOT NULL");
  $DB->query("UPDATE ibf_games_settings SET msgsys_tdisqual_text='Hello %NAME%,\n\nafter not playing for %LIMIT% days in the [b]%GAME%[/b]-Tournament you got disqualified.\n\n%LINK|Click here% to view the tournament.'");
  $missing++; }

if($DB->field_exists("scoretimeout","ibf_games_settings")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_settings` ADD `scoretimeout` tinyint NOT NULL DEFAULT '3'"); $missing++; }

if($DB->field_exists("cat","ibf_games_league")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_league` ADD cat int(11) NOT NULL default '0'"); $missing++; }

if($DB->field_exists("lid","ibf_games_league")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_league` ADD `lid` BIGINT( 20 ) NOT NULL AUTO_INCREMENT PRIMARY KEY"); $missing++; $newleague=1;}

if($DB->field_exists("nbtries","ibf_tournaments")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_tournaments` ADD `nbtries` TINYINT( 1 ) DEFAULT '3' NOT NULL"); $missing++; $truncate=1; }

if($DB->field_exists("url_discut","ibf_tournaments")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_tournaments` ADD `url_discut` VARCHAR(250) NOT NULL"); $missing++; }

if($DB->field_exists("demare","ibf_tournaments")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_tournaments` ADD `demare` TINYINT( 1 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("creat","ibf_tournaments")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_tournaments` ADD `creat` VARCHAR(30) NOT NULL"); $missing++;  $truncate=1; }

if($DB->field_exists("plibre","ibf_tournaments")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_tournaments` ADD `plibre` TINYINT( 1 ) DEFAULT '0' NOT NULL"); $missing++; }

if($DB->field_exists("cost","ibf_tournaments")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_tournaments` ADD `cost` decimal(30,5) NOT NULL DEFAULT '0.00000'"); $missing++; }

if($DB->field_exists("rungscore","ibf_tournament_players")) { $NOP=0; } else
{ $DB->query("ALTER TABLE `ibf_tournament_players` CHANGE `rungscore` `rungscore` FLOAT NOT NULL"); }

if($DB->field_exists("notified","ibf_tournament_players")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_tournament_players` ADD `notified` TINYINT(1) DEFAULT '0' NOT NULL"); $missing++; 
  $DB->query("UPDATE ibf_tournament_players SET notified=1"); }

if($DB->field_exists("champ_time","ibf_games_champs")) { $ok++; } else
{ $DB->query("ALTER TABLE `ibf_games_champs` ADD `champ_time` INT(11) DEFAULT '0' NOT NULL"); $missing++;
  $champs = 1;}

echo "done (".$missing." installed, ".$ok." existing)<br />";

// check if upgrading from < v2.5.4 then we have to truncate all Tournaments
if ($truncate==1 && $ok>0)
{
	$DB->query("TRUNCATE TABLE ibf_tournaments");
	$DB->query("TRUNCATE TABLE ibf_tournament_players");
	echo "Deleting all old Tournaments because of Upgrading to the new Tournament-System... done!<br />";
}

// check if upgrading from < v2.5.6 then we have to update the League
if ($newleague==1 && $ok>0)
{
	$settingquery = $DB->query("SELECT league_scores FROM ibf_games_settings");
	$arcade = $DB->fetch_row($settingquery);
	$arcade['league_scores'] = explode("," , $arcade['league_scores'] );

	echo "Updating the League... ";

	$DB->query("DELETE FROM ibf_games_league");

	$game_query = $DB->query("SELECT * FROM ibf_games_list WHERE active=1");
	while ($ginfo = $DB->fetch_row($game_query))
	{
		$ordering = ($ginfo['highscore_type'] == "high") ? "DESC" : "ASC";
		$ctr = 1;
		$this_query = $DB->query("SELECT mid FROM ibf_games_scores WHERE gid='".$ginfo['gid']."' ORDER BY score ".$ordering.", datescored ASC LIMIT 0,10");
		if ($DB->get_num_rows($this_query))
		{
			while($lboard = $DB->fetch_row($this_query))
			{
				switch($ctr)
				{
					case 1: $points = $arcade['league_scores'][0];
					break;
					case 2: $points = $arcade['league_scores'][1];
					break;
					case 3: $points = $arcade['league_scores'][2];
					break;
					case 4: $points = $arcade['league_scores'][3];
					break;
					case 5: $points = $arcade['league_scores'][4];
					break;
					case 6: $points = $arcade['league_scores'][5];
					break;
					case 7: $points = $arcade['league_scores'][6];
					break;
					case 8: $points = $arcade['league_scores'][7];
					break;
					case 9: $points = $arcade['league_scores'][8];
					break;
					case 10: $points = $arcade['league_scores'][9];
					break;
					default: $points = $arcade['league_scores'][10];
				}

				if ($points > 0)
				{
					$DB->query("INSERT INTO ibf_games_league (mid, gid, position, points, cat) VALUES (".$lboard['mid'].", ".$ginfo['gid'].", ".$ctr.", ".$points.", ".$ginfo['gcat'].")");
				}

				$ctr++;
			}
		}
	}
	echo "done!<br />";
}

// if upgrading from < v2.6.2 we need to update champ's times
if ($champs==1 && $ok>0)
{
	echo "Updating the champion's times...<br />";
	$updated=0;

	$game_query = $DB->query("SELECT * FROM ibf_games_list");
	while ($ginfo = $DB->fetch_row($game_query))
	{
		$ordering = ($ginfo['highscore_type'] == "high") ? "DESC" : "ASC";

		$score_query = $DB->query("	SELECT score, timespent, mid, name, datescored
						FROM ibf_games_scores
						WHERE gid=".$ginfo['gid']." ORDER BY score ".$ordering.", timespent ASC LIMIT 1");
		if ($DB->get_num_rows($score_query) > 0)
		{
			$highscore = $DB->fetch_row($score_query);

			$champ_query = $DB->query("SELECT champ_score FROM ibf_games_champs WHERE champ_gid=".$ginfo['gid']);
			$champscore = $DB->fetch_row($champ_query);

			if ( (($champscore['champ_score'] > $highscore['score']) && ($ordering=="ASC")) || (($champscore['champ_score'] < $highscore['score']) && ($ordering=="DESC")) || ($champscore['champ_score'] == $highscore['score']) )
			{
				// current highscore is better (high/low) than champ OR is same, then use fastest time
				$DB->query("UPDATE ibf_games_champs SET champ_mid   = '".$highscore['mid']."',
									champ_name  = '".$highscore['name']."',
									champ_date  = '".$highscore['datescored']."',
									champ_score = '".$highscore['score']."',
									champ_time  = '".$highscore['timespent']."'
									WHERE champ_gid=".$ginfo['gid']);
				$updated++;
			}
		}
	}
	echo "done!";
	if ($updated > 0)
	{
		echo " Updated ".$updated." champions.<br />";
	}
	else
	{
		echo "<br />";
	}
}

echo "Checking and Installing Games..........";

// it is time to insert the default games (and check if they already exist)
$game_ok=0; $game_miss=0;
$time=time();

$DB->query("SELECT gname FROM ibf_games_list WHERE gname='asteroids'");
if($DB->get_num_rows()) { $game_ok++; } else
{ $DB->query("INSERT INTO ibf_games_list (gname, gwords, gcount, gtitle, bgcolor, active, gwidth, gheight, position, gcat, object, gkeys, added, highscore_type) VALUES ('asteroids', 'Kill some asteroids and flying saucers&#33;', 0, 'Asteroids', '000', 1, 500, 375, 1, 1, 'Shoot all of the asteroids.', 'Arrow keys move the ship.<br />\r\nSpace bar fires.', $time, 'high')");
$game_miss++; }

$DB->query("SELECT gname FROM ibf_games_list WHERE gname='invaders'");
if($DB->get_num_rows()) { $game_ok++; } else
{ $DB->query("INSERT INTO ibf_games_list (gname, gwords, gcount, gtitle, bgcolor, active, gwidth, gheight, position, gcat, object, gkeys, added, highscore_type) VALUES ('invaders', 'Kill the invading army of UFO&#39;s', 0, 'Space Invaders', '000', 1, 500, 410, 1, 1, 'To shoot all of the aliens.', 'Left and Right arrow keys to move.<br />\r\nSpace bar to shoot.', $time, 'high')");
$game_miss++; }

$DB->query("SELECT gname FROM ibf_games_list WHERE gname='pacman'");
if($DB->get_num_rows()) { $game_ok++; } else
{ // ** removed -> COPYRIGHT **
}

$DB->query("SELECT gname FROM ibf_games_list WHERE gname='tetris'");
if($DB->get_num_rows()) { $game_ok++; } else
{ $DB->query("INSERT INTO ibf_games_list (gname, gwords, gcount, gtitle, bgcolor, active, gwidth, gheight, position, gcat, object, gkeys, added, highscore_type) VALUES ('tetris', 'Build solid lines to clear and get points.  Clear 4 rows at the same time and you&#39;ve just Tetris&#39;d&#33;', 0, 'Tetris', 'FFF', 1, 382, 380, 1, 1, 'Form lines using the different shapes.', 'Up arrow changes the rotation of the piece.<br />\r\nLeft and Right arrows move it.<br>\r\nDown arrow brings it down faster.', $time, 'high')");
$game_miss++; }

$DB->query("SELECT gname FROM ibf_games_list WHERE gname='snake'");
if($DB->get_num_rows()) { $game_ok++; } else
{ $DB->query("INSERT INTO ibf_games_list (gname, gwords, gcount, gtitle, bgcolor, active, gwidth, gheight, position, gcat, object, gkeys, added, highscore_type) VALUES ('snake', 'Eat the apples and don&#39;t hit the walls.... or yourself.', 0, 'Snake', '000', 1, 360, 300, 1, 1, 'Eat all of the apples.', 'Arrow keys to move.', $time, 'high')");
$game_miss++; }

$DB->query("SELECT gname FROM ibf_games_list WHERE gname='simon'");
if($DB->get_num_rows()) { $game_ok++; } else
{ $DB->query("INSERT INTO ibf_games_list (gname, gwords, gcount, gtitle, bgcolor, active, gwidth, gheight, position, gcat, object, gkeys, added, highscore_type) VALUES ('simon', 'A true test of mental agility. Follow the pattern of lights and sounds for as long as you can remember them&#33;', 0, 'Simon', '000', 1, 500, 400, 1, 1, 'Follow the pattern.', 'Click the light pattern with the mouse.', $time, 'high')");
$game_miss++; }

$DB->query("SELECT gname FROM ibf_games_list WHERE gname='hexxagon'");
if($DB->get_num_rows()) { $game_ok++; } else
{ $DB->query("INSERT INTO ibf_games_list (gname, gwords, gcount, gtitle, bgcolor, active, gwidth, gheight, position, gcat, object, gkeys, added, highscore_type) VALUES ('hexxagon', 'Flip and multiply your pieces to take over the computer.', 0, 'Hexxagon', '000', 1, 380, 300, 1, 1, 'Take over as many enemy pieces as possible.', 'Click in quadrants around your piece to move or jump.', $time, 'high')");
$game_miss++; }

$DB->query("SELECT gname FROM ibf_games_list WHERE gname='breakout'");
if($DB->get_num_rows()) { $game_ok++; } else
{ $DB->query("INSERT INTO ibf_games_list (gname, gwords, gcount, gtitle, bgcolor, active, gwidth, gheight, position, gcat, object, gkeys, added, highscore_type) VALUES ('breakout', 'Use a ball and paddle to smash your way through a series of regenerating blocks.', 0, 'Breakout', '000', 1, 382, 380, 1, 1, 'Break all of the blocks.', 'Left and Right arrows move.<br />\r\n<center>or</center>\r\nMouse moves.', $time, 'high')");
$game_miss++; }

$DB->query("SELECT gname FROM ibf_games_list WHERE gname='moonlander'");
if($DB->get_num_rows()) { $game_ok++; } else
{ $DB->query("INSERT INTO ibf_games_list (gname, gwords, gcount, gtitle, bgcolor, active, gwidth, gheight, position, gcat, object, gkeys, added, highscore_type) VALUES ('moonlander', 'Navigate your spaceship onto the different landing pads for points.  Each round the gravity gets more intense.  Each pad is worth 100 points.', 0, 'Moon Lander', '000', 1, 500, 350, 1, 1, 'Land on as many pads as possible.', 'Up key thrusts upward.<br />\r\nLeft key thrusts rightward.<br />\r\nRight key thrusts leftward.', $time, 'high')");
$game_miss++; }

echo "done (".$game_miss." installed, ".$game_ok." existing)<br />";
echo "Checking Settings......................";

// now some default data...
$cat=0;
$DB->query("SELECT cat_name FROM ibf_games_cats WHERE c_id=1");
if($DB->get_num_rows()) { $cat=0; } else
{ $DB->query("INSERT INTO ibf_games_cats (c_id, cat_name, active, show_all, pos, password, num_of_games) VALUES (1, 'Default', 1, 0, 1, '', 9)");
$cat++; }

$settings=0;
$DB->query("SELECT g_display_sort FROM ibf_games_settings");
$defset = $DB->fetch_row();
if($defset['g_display_sort']!="") { $settings=0; } else
{ $DB->query("INSERT INTO ibf_games_settings (arcade_status, g_display_sort, g_display_order, scores_amount, next_day, skin, use_cats, log, score_type, crown_type, show_new, show_new_frame, show_active, mod_notes, most_users_on, auto_prune, auto_prune_time, auto_prune_time2, banned_ips, games_pp, allow_user_skin, user_choices, def_cat, cats_per_tr, show_crowns, show_t_won, score_sep, dec_amount) VALUES (1, 'gtitle', 'ASC', 10, 0, 0, 0, 0, 'top', 1, 0, 0, '', '', 0, 0, 0, 0, '', 40, 0, '5,10,15,20,25', 1, 0, 1, 1, '0', 0)");
$settings++; }

echo "done<br />";
echo "Checking Language......................";

// check for old language-system
$oldlangsys1=""; $oldlangsys2=""; $oldlangsys3="";
if($DB->field_exists("phrasetypeid","ibf_phrase"))
{
	$oldlangsys1 = ", `phrasetypeid`";
	$oldlangsys2 = ", 1";
	$oldlangsys3 = ", 25";
}

// ACP language phrases (default english) for vBulletin, automatic change/translation via AdminCP-settings
$lang_ok=0; $lang_miss=0;

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu0'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu0', 'Arcade'".$oldlangsys2.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu1'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu1', 'Arcade Main Settings'".$oldlangsys2.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu2'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu2', 'Games List'".$oldlangsys2.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu3'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu3', 'Categories'".$oldlangsys2.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu4'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu4', 'Add Game'".$oldlangsys2.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu5'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu5', 'Tournaments'".$oldlangsys2.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu6'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu6', 'Group Permissions'".$oldlangsys2.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu7'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu7', 'Member Manage'".$oldlangsys2.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu8'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu8', 'IP Banning'".$oldlangsys2.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu9'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu9', 'Score Tools'".$oldlangsys2.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu10'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu10', 'Custom Game Sorting'".$oldlangsys2.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibparcade_acpmenu11'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibparcade_acpmenu11', 'Notifications'".$oldlangsys2.")");
$lang_miss++; }

// WOL language phrases (default: english), could be automagically changed through AdminCP-settings
$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibproarcade_home'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibproarcade_home', 'Arcade'".$oldlangsys3.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibproarcade_playing_game'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibproarcade_playing_game', 'Playing Game'".$oldlangsys3.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibproarcade_viewing_highscores'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibproarcade_viewing_highscores', 'Viewing Arcade Highscores'".$oldlangsys3.")");
$lang_miss++; }

$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibproarcade_viewing_home'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibproarcade_viewing_home', 'Viewing Arcade Home'".$oldlangsys3.")");
$lang_miss++; }

// Postbit phrases (default: english), could be automagically changed through AdminCP-settings
$DB->query("SELECT varname FROM ibf_phrase WHERE varname='ibpa_tourney'");
if($DB->get_num_rows()) { $lang_ok++; } else
{ $DB->query("INSERT INTO `ibf_phrase` (`languageid`, `varname`, `text`".$oldlangsys1.") VALUES (0, 'ibpa_tourney', 'Tournaments Won:'".$oldlangsys2.")");
$lang_miss++; }

echo "done (".$lang_miss." installed, ".$lang_ok." existing)<br />";

echo "<br />";
echo "<br />";
echo "You're done, enjoy ibProArcade";

}

else

{

echo "Welcome to ibProArcade ".$version."<br />";
echo "==============================<br />";
echo "<br />";
echo "<br />";
echo "This Script will do all adaptions to the Database that are needed.<br />";
echo "<br />";
echo "<a href='installer.php?do=go'>Click here to START</a>";
exit;

}

?>